﻿$(document).on("pageinit", function () {
    var context = $("[data-questiontype='text']");

    $('textarea[maxlength]', context).on("keypress", function () {
        var maxLength = parseInt($(this).attr('maxlength'));
        var length = $(this).val().length;
        return length < maxLength;
    });

    $("input, textarea", context).on("keyup change", function () {
        var container = $(this).closest(".questionContainer");
        var choices = $("[name=C-" + $(this).attr("name") + "]", container);
        choices.prop("checked", false).checkboxradio("refresh");
    });

    $(":radio", context).on("change", function () {
        ClearTextBox($(this));
    });

    $(":radio.softPromptChoice").each(function () {
        var uiradio = $(this).closest(".ui-radio");
        uiradio.addClass("softPromptChoice");
        uiradio.hide();
    });

    if ($.fn.autoNumeric) {
        $("input.numericAnswer:not(.rankingItem)").autoNumeric({ "vMax": 9223372036854775808.99, "vMin": -9223372036854775808.99 });
    }
});

function ClearTextBox(choice) {
    var container = choice.closest(".questionContainer");
    var editBox = $("[name=" + choice.attr("name").substring(2) + "]", container);
    editBox.val("");
}